#!/usr/bin/env python3

# Input validator

import sys
import re

pat = re.compile('[a-z]{1,20}')

st = set(range(1, 7))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n = int(fi.readline().strip())
if 1 > n or n > 100_000:
    sys.exit(f'N out of range')
print(n, file=fo)
if n > 100:
    st -= set(range(1, 6))

for i in range(n):
    s = fi.readline().strip()
    if not pat.match(s):
        sys.exit(f'Invalid word {1+i}')
    print(s, file=fo)
    if len(s) != 1:
        st.discard(1)
    if len(s) != 2:
        st.discard(2)
    if len(s) > 3:
        st.discard(3)
    if len(s) > 8:
        st.discard(4)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
