// Kasutab sõna tähtede multihulga esitusena sorteeritud jada (täpsemalt string)
// Samamoodi kasutab grupi liikmete multihulga esitusena jada (täpsemalt vector)

#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <algorithm>
using namespace std;

using key = string;
using value = vector<string>;

int main() {
	int n; cin >> n;

	map<key, value> grupid;
	for (int i = 0; i < n; ++i) {
		string s; cin >> s;
		// teeme s tähtedest multihulga
		// esitame selle sõnena, milles tähed on soreer
		key t(begin(s), end(s));
		sort(begin(t), end(t));
		// lisame s tema tähtedele vastavasse gruppi
		grupid[t].push_back(s);
	}

	cout << grupid.size() << "\n";
	for (const auto & [_, grupp] : grupid) {
		cout << grupp.size() << "\n";
		for (const auto & s : grupp) {
			cout << s << "\n";
		}
	}
}
