#!/usr/bin/env python3

# Input validator

import sys

st = set(range(1, 6))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n, q = (int(v) for v in fi.readline().split())
if 1 > n or n > 1_000:
    sys.exit(f'N out of range')
if 1 > q or q > 10_000:
    sys.exit(f'Q out of range')
print(n, q, file=fo)
if n > 5:
    st.discard(1)
    st.discard(2)
    st.discard(3)
if q > 200:
    st.discard(1)
    st.discard(2)
    st.discard(3)
    st.discard(4)

for i in range(n):
    k, r, f = (int(v) for v in fi.readline().split())
    if 1 > k or k > 32:
        sys.exit(f'K[{1+i}] out of range')
    if 1 > r or r > 40_000:
        sys.exit(f'R[{1+i}] out of range')
    if r**k > 2**31:
        sys.exit(f'R^K[{1+i}] out of range')
    if 0 > f or f > 1_000:
        sys.exit(f'F[{1+i}] out of range')
    print(k, r, f, file=fo)
    if k > 6:
        st.discard(1)
        st.discard(2)
    if r > 100:
        st.discard(1)
    if r > 200:
        st.discard(2)
        st.discard(3)
        st.discard(4)
    if r**k > 1e6:
        st.discard(1)

for j in range(q):
    h = int(fi.readline().strip())
    if 1 > h or h > 100_000:
        sys.exit(f'H[{1+j}] out of range')
    print(h, file=fo)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
