#include "testlib.h"
#include <vector>

using namespace std;

vector<int> read_ans (InStream &in, int n, int otc) {
  vector<int> out;
  for (int i = 0; i < otc; i++) {
    out.push_back(in.readInt(1, n));
  }
  return out;
}

int main (int argc, char **argv) {
  registerTestlibCmd(argc, argv);

  int n = inf.readInt();
  int qc = inf.readInt();

  vector<int> qtypes; // type of the i-th "output" query
  for (int i = 0; i < qc; i++) {
    int typ = inf.readInt();
    if (typ == 1) {
      inf.readInt();
      inf.readInt();
    } else if (typ == 2) {
      inf.readInt();
      qtypes.push_back(typ);
    } else if (typ == 3) {
      inf.readInt();
      qtypes.push_back(typ);
    }
  }

  auto ja = read_ans(ans, n, qtypes.size());
  auto pa = read_ans(ouf, n, qtypes.size());

  bool ok2 = true, ok3 = true;
  for (int i = 0; i < (int) qtypes.size(); i++) {
    if (ja[i] != pa[i]) {
      if (qtypes[i] == 2)
        ok2 = false;
      else
        ok3 = false;
    }
  }

  if (ok2 && ok3) {
    quitf(_ok, "translate:success");
  } else if (ok2) {
    quitp(0.6, "type 2 ok, type 3 not");
  } else {
    quitf(_wa, "translate:wrong");
  }
}
