#include "testlib.h"
#include <optional>

using namespace std;

template<typename T>
optional<T> oopt (string name) {
  if (__testlib_opts.count(name))
    return opt<T>(name);
  else
    return {};
}

template<typename T>
T opt_with_default (string name, T def) {
  if (__testlib_opts.count(name))
    return opt<T>(name);
  else
    return def;
}

int main (int argc, char **argv) {
  registerGen(argc, argv, 1);

  int n = opt<int>("n");
  int qc = opt<int>("qc");
  bool no3 = oopt<bool>("no3").has_value();
  bool explr = oopt<bool>("explr").has_value();
  int explrwnx = opt_with_default<int>("explrwnx", 0);

  cout << n << " " << qc << '\n';
  for (int i = 0; i < qc; i++) {
    int typ = rnd.next(1, no3 ? 2 : 3);
    if (typ == 1) {
      int l, r;
      if (explr) {
        int k;
        do {
          k = rnd.wnext(0, 20, explrwnx);
        } while ((n >> k) - 1 < 1);

        int x = rnd.next(1, (n >> k) - 1);

        l = x << k;
        r = ((x + 1) << k) - 1;
      } else {
        l = rnd.next(1, n);
        r = rnd.next(1, n);
        if (l > r)
          swap(l, r);
      }

      cout << typ << " " << l << " " << r << '\n';
    } else {
      int x = rnd.next(1, n);
      cout << typ << " " << x << '\n';
    }
  }
}
