#!/usr/bin/env python3

# Input validator

import sys

st = set(range(1, 4))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n, q = (int(i) for i in fi.readline().split())
if 1 > n or 1 > 3e5:
    sys.exit(f'N out of range')
if 1 > q or q > 3e5:
    sys.exit(f'Q out of range')
print(n, q, file=fo)
if n > 1000 or q > 1000:
    st.discard(1)

for i in range(q):
    t = tuple(int(v) for v in fi.readline().split())
    if t[0] == 1:
        if len(t) != 3:
            sys.exit(f'Query {1+i}: invalid format')
        if 1 > t[1] or t[1] > t[2] or t[2] > n:
            sys.exit(f'Query {1+i}: parameters out of range')
        st2 = False
        for b in range(n):
            if 2**b > t[1]:
                break
            a = t[1] // 2**b
            if t[1] == a * 2**b and t[2] == (a + 1) * 2**b - 1:
                st2 = True
        if not st2:
            st.discard(2)
    elif t[0] == 2 or t[0] == 3:
        if len(t) != 2:
            sys.exit(f'Query {1+i}: invalid format')
        if 1 > t[1] or t[1] > n:
            sys.exit(f'Query {1+i}: parameter out of range')
    else:
        sys.exit(f'Query {1+i}: invalid type')
    print(*t, file=fo)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
