import random
import sys

class Node:
    def __init__ (self, val):
        self.count = 1
        self.priority = random.randrange(0, 1 << 32)
        self.lch = None
        self.rch = None
        self.par = None
        self.lazy = False
        self.value = val

    def update (self):
        self.count = 1
        if self.lch is not None:
            self.count += self.lch.count
        if self.rch is not None:
            self.count += self.rch.count

    def propagate (self):
        if self.lazy:
            self.lch, self.rch = self.rch, self.lch
            if self.lch is not None:
                self.lch.lazy ^= 1
            if self.rch is not None:
                self.rch.lazy ^= 1
            self.lazy = False

def split (count, cur):
    if cur is None:
        return None, None

    cur.propagate()
    if count == 0 or cur.lch is not None and count <= cur.lch.count:
        ret = split(count, cur.lch)
        cur.lch = ret[1]
        if cur.lch is not None:
            cur.lch.par = cur
        result = ret[0], cur
    else:
        if cur.lch is not None:
            count -= cur.lch.count
        count -= 1

        ret = split(count, cur.rch)
        cur.rch = ret[0]
        if cur.rch is not None:
            cur.rch.par = cur
        result = cur, ret[1]

    cur.par = None
    cur.update()
    return result

def merge (left, right):
    if left is None:
        return right
    if right is None:
        return left

    left.propagate()
    right.propagate()

    if left.priority < right.priority:
        left.rch = merge(left.rch, right)
        if left.rch is not None:
            left.rch.par = left
        top = left
    else:
        right.lch = merge(left, right.lch)
        if right.lch:
            right.lch.par = right
        top = right

    top.update()
    return top

def find (cur, count):
    assert cur is not None
    cur.propagate()

    if cur.lch is not None:
        if count < cur.lch.count:
            return find(cur.lch, count)
        count -= cur.lch.count

    if count == 0:
        return cur
    count -= 1

    if cur.rch is not None:
        return find(cur.rch, count)

    return None

class Treap:
    def __init__ (self):
        self.root = None
    
    def push_back (self, value):
        created = Node(value)
        cur = merge(self.root, created)
        self.root = cur
        return created

def main ():
    n, qc = map(int, sys.stdin.readline().strip().split())

    nodeof = []
    treap = Treap()
    for i in range(n + 1):
        nodeof.append(treap.push_back(i))

    for i in range(qc):
        tokens = list(map(int, sys.stdin.readline().strip().split()))
        typ = tokens[0]

        if typ == 1:
            l = tokens[1]
            r = tokens[2]

            LM, R = split(r + 1, treap.root)
            L, M = split(l, LM)
            if M is not None:
                M.lazy ^= 1

            LM = merge(L, M)
            treap.root = merge(LM, R)
        elif typ == 2:
            x = tokens[1]
            node = find(treap.root, x)
            sys.stdout.write(str(node.value))
            sys.stdout.write("\n")
        else:
            y = tokens[1]

            cur = nodeof[y]
            pos = cur.lch.count if cur.lch is not None else 0
            if cur.lazy:
                pos = cur.count - pos - 1

            while cur.par is not None:
                par = cur.par
                assert cur is par.lch or cur is par.rch

                if cur == par.rch:
                    pos += 1
                    if par.lch is not None:
                        pos += par.lch.count

                if par.lazy:
                    pos = par.count - pos - 1

                cur = par

            sys.stdout.write(str(pos))
            sys.stdout.write("\n")

if __name__ == "__main__":
    main()
