#include <iostream>
#include <vector>

using namespace std;

struct Node {
  int val;
  
  Node *lch;
  Node *rch;
  Node *par;

  int width;
  bool lazy;
};

void propagate (Node *node) {
  if (!node->lazy) {
    return;
  }

  swap(node->lch, node->rch);
  if (node->lch)
    node->lch->lazy ^= 1;
  if (node->rch)
    node->rch->lazy ^= 1;

  node->lazy = 0;
}

Node* find (Node *cur, int pos, int width) {
  propagate(cur);
  
  if (pos == 0) {
    if (width == cur->width)
      return cur;

    return find(cur->lch, pos, width);
  }

  if (pos < cur->lch->width)
    return find(cur->lch, pos, width);
  else
    return find(cur->rch, pos - cur->lch->width, width);
}

int main () {
  ios::sync_with_stdio(false);
  cin.tie(0);
  
  int _n, qc;
  cin >> _n >> qc;

  _n++;
  int n = 1;
  while (n < _n)
    n *= 2;

  vector<Node*> nodeof (n);
  for (int i = 0; i < n; i++) {
    nodeof[i] = new Node();
    nodeof[i]->val = i;
    nodeof[i]->lch = nodeof[i]->rch = nodeof[i]->par = 0;
    nodeof[i]->width = 1;
    nodeof[i]->lazy = 0;
  }

  vector<Node*> cur = nodeof;
  while (cur.size() > 1) {
    vector<Node*> nxt;
    for (int i = 0; i < (int) cur.size(); i += 2) {
      auto node = new Node();
      
      node->lch = cur[i];
      cur[i]->par = node;

      node->rch = cur[i + 1];
      cur[i + 1]->par = node;

      node->par = 0;

      node->width = cur[i]->width + cur[i + 1]->width;
      node->lazy = 0;

      nxt.push_back(node);
    }

    cur = nxt;
  }

  auto root = cur[0];
  
  for (int i = 0; i < qc; i++) {
    int typ;
    cin >> typ;

    if (typ == 1) {
      int l, r;
      cin >> l >> r;
      r++;

      int width = r - l;
      auto node = find(root, l, width);
      node->lazy ^= 1;
    } else if (typ == 2) {
      int x;
      cin >> x;

      auto node = find(root, x, 1);
      cout << node->val << '\n';
    } else {
      int y;
      cin >> y;

      auto cur = nodeof[y];
      int pos = 0;
      while (cur->par) {
        auto par = cur->par;

        if (cur == par->rch)
          pos += par->lch->width;

        if (par->lazy)
          pos = par->width - pos - 1;

        cur = par;
      }

      cout << pos << '\n';
    }
  }
}
