#!/usr/bin/env python3

# Input validator

import sys

st = set(range(1, 3))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

kx, ky = (int(i) for i in fi.readline().split())
if -1e9 > kx or kx > 1e9:
    sys.exit(f'Kx out of range')
if -1e9 > ky or ky > 1e9:
    sys.exit(f'Ky out of range')
print(kx, ky, file=fo)

dx, dy = (int(i) for i in fi.readline().split())
if -1e9 > dx or dx > 1e9:
    sys.exit(f'Dx out of range')
if -1e9 > dy or dy > 1e9:
    sys.exit(f'Dy out of range')
print(dx, dy, file=fo)

n = int(fi.readline().strip())
if 0 > n or n > 1e3:
    sys.exit(f'N out of range')
print(n, file=fo)
if n > 3:
    st.discard(1)

for i in range(n):
    x, y, r = (int(v) for v in fi.readline().split())
    if -1e9 > x or x > 1e9:
        sys.exit(f'X[{1+i}] out of range')
    if -1e9 > y or y > 1e9:
        sys.exit(f'Y[{1+i}] out of range')
    if 1 > r or r > 1e9:
        sys.exit(f'R[{1+i}] out of range')
    print(x, y, r, file=fo)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
