#include <bits/stdc++.h>
typedef long long ll;
typedef long double ld;
using namespace std;
typedef pair<ld,ll> kaugusJaIndeks;

/**
Klass, mis hoiab kiki sisendi raadiusega ringe, kusjuures Delta ja Kaarsild on raadiusega 0
*/
struct Ring {
    ll x,y,r;
    string nimi;
    Ring(ll x,ll y,ll r,string nimi):x(x),y(y),r(r),nimi(nimi){}
};

/**
Funktsioon kahe ringi vahelise kauguse arvutamiseks
*/
ld ringideKaugus(const Ring& A, const Ring& B){
    ld dx = A.x - B.x;
    ld dy = A.y - B.y;
    ld d = sqrt(dx*dx + dy*dy) - (A.r + B.r);
    return max(d, (ld)0);
}

/**
Lahendusfunktsioon phineb Dijkstra algoritmil
*/
vector<pair<Ring,Ring>> luhimTee(const vector<Ring>& punktid,int algus,int lopp){
    int N=punktid.size();

    vector<ld>kaugusAlgusest(N,numeric_limits<ld>::max());//Hoiame meeles iga punkti jooksvat kaugust alguspunktist
    kaugusAlgusest[algus]=0;//alguspunkti kaugus endast on 0

    vector<int>eelmineTippTeekonnal(N,-1);
    //Lpus lhima teekonna vljastamiseks hoiame jooksvalt meeles, mis punktist me igasse punkti liikusime,
    //oluline on just vahetult eelnev punkt

    priority_queue<kaugusJaIndeks,vector<kaugusJaIndeks>,greater<kaugusJaIndeks>>pq;
    //Dijkstra algoritmi tvoogu hoiame priority_queue's, mis tagastab meile igal sammul alguspunktile lhima punkti
    pq.push({0,algus});//Algtipu kohta on kohe teada, et ta on kaugusel 0

    while(!pq.empty()){
        auto vahim=pq.top();pq.pop();//leiame alguspunktile lhima punkti
        int U=vahim.second;//see on tema indeks punktide vektoris

        if(vahim.first != kaugusAlgusest[U])//Selleks hetkeks on tipu kaugus algusest juba lplikult kindel,
                                            //kuid queues vib olla ka suurema kaugusega selle punkti esitusi mida ignoreerime
            continue;

        for(int V=0;V<N;V++){//Vaatame lbi kik lejnud punktid
            ld kaugusUV = ringideKaugus(punktid[U],punktid[V]);//Kui kaugel on punktid U ja V ksteisest

            if(kaugusAlgusest[U]+kaugusUV<kaugusAlgusest[V]){//Kas teekond algusest puntki V saaks lhem,
                                                             //kui lheksime lhimat teed mda algusest puntki U ja sealt otse punkti V
                kaugusAlgusest[V]=kaugusAlgusest[U]+kaugusUV;//Jah, uuendame kaugust
                eelmineTippTeekonnal[V]=U;                   //Tulime tipust U
                pq.push({kaugusAlgusest[V],V});              //Lisame uuenduse tvoogu
            }
        }
    }

    vector<pair<Ring,Ring>> vastus;

    while(eelmineTippTeekonnal[lopp]!=-1){//Liigume samm-sammult lpp-punktist algusesse ja lisame vihma kes olekud vastusesse
        int U=eelmineTippTeekonnal[lopp],V=lopp;
        ld kaugusUV=ringideKaugus(punktid[U],punktid[V]);
        if(kaugusUV != 0){//Olime vihma kes, jrelikult lisame ligu vastusesse
            vastus.push_back({punktid[U],punktid[V]});
        }
        lopp=eelmineTippTeekonnal[lopp];
    }
    reverse(vastus.begin(),vastus.end());//Liikusime tskliga lpust algusesse, seega prame vastuse mber ja tagastame selle
    return vastus;
}
int main()
{ios_base::sync_with_stdio(0);cin.tie(0);cout.tie(0);
    vector<Ring>ringid;//Salvestame kik sisend punktid hte vektorisse

    ll x,y;
    cin>>x>>y;
    ringid.push_back(Ring(x,y,0,"Kaarsild"));//Kaarsild ja Delta on meie vaates raadiusega 0 ringid
    cin>>x>>y;
    ringid.push_back(Ring(x,y,0,"Delta"));//Lisame mlemad vektori algussse

    int N;
    cin>>N;
    for(int i=1;i<=N;i++){//Seejrel loeme sisendist puuvrad ehk lejnud ringid
        ll x,y,r;
        cin>>x>>y>>r;
        ringid.push_back(Ring(x,y,r,to_string(i)));
    }

    auto vastus=luhimTee(ringid,0,1);//Leiame lhima tee ja vljastame selle likude kaupa
    cout<<vastus.size()<<endl;
    for(auto loik:vastus){
        cout<<loik.first.nimi<<" "<<loik.second.nimi<<endl;
    }
    return 0;
}
