#Klass, mis hoiab kõiki sisendi raadiusega ringe,
#kusjuures Delta ja Kaarsild on raadiusega 0
class Ring:
    def __init__(self,x,y,r,nimi):
        self.x=x
        self.y=y
        self.r=r
        self.nimi=nimi
    
#Funktsioon kahe ringi vahelise kauguse arvutamiseks
def ringideKaugus(A,B):
    dx=A.x-B.x
    dy=A.y-B.y
    d=(dx**2+dy**2)**0.5-(A.r+B.r)
    return max(d,0)

#Lahendusfunktsioon põhineb Dijkstra algoritmil
def luhimTee(ringid,algus,lopp):
    N=len(ringid)
    
    kaugusAlgusest=[float('inf') for _ in range(N)]
    #Hoiame meeles iga punkti jooksvat kaugust alguspunktist
    #Alguses lõpmatus
    kaugusAlgusest[algus]=0#alguspunkti kaugus endast on 0
    
    eelmineTippTeekonnal=[-1 for _ in range(N)]
    #Lõpus lühima teekonna väljastamiseks hoiame jooksvalt meeles,
    #mis punktist me igasse punkti liikusime,
    #oluline on just vahetult eelnev punkt
    
    kylastatud=[0 for _ in range(N)]
    #Hoiame meeles, mis ringideni oleme lõpliku tee juba leidnud
    
    for i in range(N):
        vahim=min([(kaugusAlgusest[i],i) for i in range(N) if kylastatud[i]==0])
        U=vahim[1]#Igal sammul leiame Kaarsillale lähima ringi,
                  #mida pole veel külastanud
        kylastatud[U]=1#Nüüd oleme külastanud
        
        for V in range(N):#Ning proovime iga tipu kaugust tipu U kaudu vähendada
            kaugusUV=ringideKaugus(ringid[U],ringid[V])
            if(kaugusAlgusest[U]+kaugusUV<kaugusAlgusest[V]):
                #Kas teekond algusest puntki V saaks lühem,
                #kui läheksime lühimat teed mööda algusest
                #puntki U ja sealt otse punkti V
                kaugusAlgusest[V]=kaugusAlgusest[U]+kaugusUV#Jah, uuendame kaugust
                eelmineTippTeekonnal[V]=U#Tulime tipust U
                
    vastus=[]
    while eelmineTippTeekonnal[lopp]!=-1:
        #Liigume samm-sammult lõpp-punktist algusesse ja lisame vihma käes olekud vastusesse
        U,V=eelmineTippTeekonnal[lopp],lopp
        kaugusUV=ringideKaugus(ringid[U],ringid[V])
        if(kaugusUV != 0): #Olime vihma käes, järelikult lisame lõigu vastusesse
            vastus.append([ringid[U],ringid[V]])
        lopp=eelmineTippTeekonnal[lopp]
    vastus=vastus[::-1]
    #Liikusime tsükliga lõpust algusesse, seega pöörame vastuse ümber ja tagastame selle
    return vastus

ringid=[]#Salvestame kõik sisend punktid ühte listi ringidest

x,y=map(int,input().split())#Kaarsild ja Delta on meie vaates raadiusega 0 ringid
ringid.append(Ring(x,y,0,"Kaarsild"))
x,y=map(int,input().split())
ringid.append(Ring(x,y,0,"Delta"))

N=int(input())
for i in range(1,N+1):#Seejärel loeme sisendist puuvõrad ehk ülejäänud ringid
    x,y,r=map(int,input().split())
    ringid.append(Ring(x,y,r,str(i)))
    
vastus=luhimTee(ringid,0,1)#Leiame lühima tee 
print(len(vastus))
for rida in vastus:#ja väljastame selle lõikude kaupa
    print(rida[0].nimi,rida[1].nimi)