#include <iostream>
#include <fstream>
#include <string>
#include <set>
#include <vector>
#include <algorithm>
using namespace std;

#define done(r, m) (cout << r << '\n', cerr << m << '\n', exit(0))

int main(int argc, const char *argv[]) {
	if (argc != 4) {
		done(0, "Usage: " << argv[0] << " input hint output");
	}

	ifstream in(argv[1]);
	ifstream hint(argv[2]);
	ifstream out(argv[3]);

	int t; in >> t;
	for (int i = 0; i < t; ++i) {
		int n, m; in >> n >> m;
		set<pair<int, int>> ab;
		for (int j = 0; j < m; ++j) {
			int a, b; in >> a >> b;
			ab.insert({a, b});
		}

		string ah; hint >> ah;
		string ao; out >> ao;
		if (!out) done(0, "Invalid format");
		if (ao != ah) done(0, "Wrong answer");
		if (ah == "YES") {
			vector<int> q(4);
			for (auto & x : q) hint >> x; // read and discard hint
			for (auto & x : q) out >> x;
			if (!out) done(0, "Invalid format");
			sort(begin(q), end(q));
			if (1 > q.front() or q.back() > n) done(0, "Wrong answer");
			int c = 0;
			for (auto i1 = begin(q); i1 != end(q); ++i1) {
				for (auto i2 = i1; ++i2 != end(q); ) {
					if (*i1 == *i2) done(0, "Wrong answer");
					c += ab.count({*i1, *i2});
				}
			}
			if (c != 5) done(0, "Wrong answer");
		}
	}

	char c; out >> c;
	if (out) done(0, "Invalid format");
	done(1, "OK");
}
