#include "oi.h"
#undef cout
#undef printf
#include <bits/stdc++.h>
using namespace std;

oi::Random rng;

// Change this function to generate one test for stresstesting.
// The script prog/abcingen.sh in 10 seconds generates as much tests as possible
// and compares the outputs of the model solution and brute solution.
// The tests shouldn't be very big, but should be able to cover edge cases.
void gen_stresstest() {
    int testy = rng(1, 1000);
    cout << testy << "\n";
    while(testy--){
        int n = rng(1, 10);
        double p = rng(0.0, 1.0);
        
        vector<pair<int, int>> kraw;
        for(int i = 1; i <= n; ++i) for(int j = i+1; j <= n; ++j){
            double tmp = rng(0.0, 1.0);
            if(tmp < p) kraw.emplace_back(i, j);
        }

        rng.shuffle(kraw);
        cout << n << " " << kraw.size() << "\n";
        for(auto [a, b] : kraw) cout << a << " " << b << "\n";
    }
}

void gen_0() {
    cout << "2\n";

    cout << "6 8\n";
    cout << "3 6\n";
    cout << "4 5\n";
    cout << "1 5\n";
    cout << "2 6\n";
    cout << "1 3\n";
    cout << "5 6\n";
    cout << "3 5\n";
    cout << "1 2\n";

    cout << "4 6\n";
    for(int i = 1; i <= 4; ++i) for(int j = i+1; j <= 4; ++j)
        cout << i << " " << j << "\n";
}

void gen_1ocen(){
    cout << 6 << "\n";
    auto wypisz = [&](int x, int y){
        cout << 4 << " " << 5 << "\n";
        vector<pair<int, int>> kraw;
        for(int i = 1; i <= 4; ++i) for(int j = 1; j < i; ++j) if(j != x || i != y) kraw.emplace_back(j, i);
        rng.shuffle(kraw.begin(), kraw.end());
        for(auto [a, b] : kraw) cout << a << " " << b << "\n";
    };
    vector<pair<int, int>> kraw;
    for(int i = 1; i <= 4; ++i) for(int j = 1; j < i; ++j) kraw.emplace_back(j, i);
    rng.shuffle(kraw.begin(), kraw.end());
    for(auto [a, b] : kraw) wypisz(a, b);
}

void gen_2ocen(){
    cout << 1 << "\n";
    cout << 1000 << " " << 0 << "\n";
}

void gen_3ocen(){
    int n = 400;
    vector<pair<int, int>> kraw;
    for(int i = 1; i <= n; ++i) for(int j = 1; j < i; ++j) kraw.emplace_back(j, i);
    int m = (int)kraw.size();
    rng.shuffle(kraw.begin(), kraw.end());
    cout << 1 << "\n";
    cout << n << " " << m << "\n";
    for(auto [a, b] : kraw) cout << a << " " << b << "\n";
}

void gen_4ocen(){
    int n = 100'000;
    cout << 1 << "\n";
    cout << n << " " << n << "\n";
    for(int i = 1; i < n; ++i) cout << i << " " << i+1 << "\n";
    cout << 1 << " " << n << "\n";
}

void gen_losowe(int n, int m, int suma_n, int suma_m){
    int testy = suma_n/n;
    if(m) testy = min(testy, suma_m/m);
    cout << testy << "\n";
    while(testy--){
        cout << n << " " << m << "\n";
        if(n <= 500){
            vector<pair<int, int>> kr;
            for(int i = 1; i <= n; ++i) for(int j = i+1; j <= n; ++j) kr.emplace_back(i, j);
            rng.shuffle(kr.begin(), kr.end());
            for(int i = 0; i < m; ++i) cout << kr[i].first << " " << kr[i].second << "\n";
        }
        else{
            set<pair<int, int>> kraw;
            for(int i = 0; i < m; ++i){
                while(1){
                    int a = rng(1, n);
                    int b = rng(1, n);
                    if(a == b) continue;
                    if(a > b) swap(a, b);
                    if(kraw.count({a, b})) continue;
                    kraw.emplace(a, b);
                    cout << a << " " << b << "\n";
                    break;
                }
            }
        }
    }
}

void gen_klika(int n){
    cout << "1\n";
    cout << n << " " << n*(n-1)/2 << "\n";
    for(int i = 1; i <= n; ++i) for(int j = i+1; j <= n; ++j) cout << i << " " << j << "\n";
}

void gen_klika_i_diament(int n){
    cout << "1\n";
    cout << n+4 << " " << n*(n-1)/2 + 7 << "\n";
    for(int i = 1; i <= n; ++i) for(int j = i+1; j <= n; ++j) cout << i << " " << j << "\n";
    for(int i = n+1; i <= n+4; ++i) for(int j = i+1; j <= n+4; ++j){
        if(i != n+1 || j != n+2) cout << i << " " << j << "\n";
    }
    cout << 16 << " " << n+1 << "\n";
    cout << 55 << " " << n+2 << "\n";
}

void gen_cztery_kliki(int m){
    int n = 1;
    while(4 * n*(n-1)/2 + 5 <= m) ++n;
    --n;

    cout << "1\n";
    cout << 4*n << " " << 4 * n*(n-1)/2 + 5 << "\n";

    vector<int> perm(4*n+1);
    for(int i = 1; i <= 4*n; ++i) perm[i] = i;
    rng.shuffle(perm.begin()+1, perm.end());

    auto wypisz = [&](int a, int b){
        a = perm[a], b = perm[b];
        if(a > b) swap(a, b);
        cout << a << " " << b << "\n";
    };
    for(int i = 0; i < 4; ++i)
        for(int j = 1; j <= n; ++j)
            for(int k = j+1; k <= n; ++k)
                wypisz(j + i*n, k + i*n);
    wypisz(n, 2*n);
    wypisz(n, 3*n);
    wypisz(n, 4*n);
    wypisz(2*n, 3*n);
    wypisz(2*n, 4*n);
}

void gen_sloneczko(int n){
    cout << 1 << "\n";
    cout << n << " " << n-1 << "\n";
    int korzen = rng(1, n);
    for(int i = 1; i <= n; ++i) if(i != korzen){
        int a = i, b = korzen;
        cout << min(a, b) << " " << max(a, b) << "\n";
    }
}

// void gen_losowy_dwudzielny(int n, int m, int k){
//     int raz = n/2;
//     vector<int> perm(n+1);
//     for(int i = 1; i <= n; ++i) perm[i] = i;
//     rng.shuffle(1+perm.begin(), perm.end());

//     set<pair<int, int>> secik;
//     auto dod = [&](int a, int b){
//         if(a > b) swap(a, b);
//         secik.emplace(a, b);
//     };
//     for(int i = 0; i < k; ++i){
//         int a = perm[1 + 2*i], b = perm[1 + 2*i+1];
//         int c = perm[raz+1 + 2*i], d = perm[raz+1 + 2*i+1];
//         dod(a, c);
//         dod(a, d);
//         dod(b, c);
//         dod(b, d);
//         dod(a, b);
//     }

//     while((int)secik.size() < m){
//         int a = rng(1, raz);
//         int b = rng(raz+1, n);
//         dod(perm[a], perm[b]);
//     }

//     cout << "1\n";
//     cout << n << " " << m << "\n";
//     for(auto [a, b] : secik) cout << a << " " << b << "\n";
// }

void gen_bijekcja_klik(int m){
    int k = 1;
    while(2 * k*(k-1)/2 + k + 1 <= m) ++k;
    --k;
    int n = 2*k;
    vector<int> perm(n+1);
    for(int i = 1; i <= n; ++i) perm[i] = i;
    rng.shuffle(1+perm.begin(), perm.end());
    set<pair<int, int>> secik;
    auto dod = [&](int a, int b){
        if(a > b) swap(a, b);
        secik.emplace(a, b);
    };
    for(int i = 1; i <= k; ++i) for(int j = 1; j < i; ++j) dod(perm[i], perm[j]), dod(perm[k+i], perm[k+j]);
    for(int i = 1; i <= k; ++i) dod(perm[i], perm[i+k]);
    dod(perm[1], perm[k+2]);

    cout << "1\n";
    cout << n << " " << secik.size() << "\n";
    for(auto [a, b] : secik) cout << a << " " << b << "\n";
}

void gen_dwie_kliki_dwie_gwiazdki(int m){
    int k = 1;
    while(2 * k*(k-1)/2 + k+k-1 <= m) ++k;
    --k;
    int n = 2*k;
    vector<int> perm(n+1);
    for(int i = 1; i <= n; ++i) perm[i] = i;
    rng.shuffle(1+perm.begin(), perm.end());
    set<pair<int, int>> secik;
    auto dod = [&](int a, int b){
        if(a > b) swap(a, b);
        secik.emplace(a, b);
    };
    for(int i = 1; i <= k; ++i) for(int j = 1; j < i; ++j) dod(perm[i], perm[j]), dod(perm[k+i], perm[k+j]);
    for(int i = 1; i <= k; ++i) dod(perm[i], perm[k+1]), dod(perm[k+i], perm[1]);

    cout << "1\n";
    cout << n << " " << secik.size() << "\n";
    for(auto [a, b] : secik) cout << a << " " << b << "\n";
}

void gen_graf_bijekcji_klik(int maks_n, int k){
    int rozmiar = maks_n / k;
    int n = rozmiar * k;
    vector czy(k, vector<int>(k, 0));

    for(int i = 0; i < k; ++i) for(int j = 0; j < k; ++j) czy[i][j] = rng(0, 1);

    int wielkosc_bijekcji = rozmiar;
    for(int i = 0; i < k; ++i){
        int sas = 0;
        for(int j = 0; j < k; ++j) if(czy[i][j]) ++sas;
        if(!sas) continue;
        wielkosc_bijekcji = min(wielkosc_bijekcji, rozmiar / sas);
    }

    vector<int> licznik(k);
    for(int i = 0; i < k; ++i) licznik[i] = i*rozmiar;
    set<pair<int, int>> secik;
    for(int i = 0; i < k; ++i){
        for(int a = 0; a < rozmiar; ++a) for(int b = 0; b < a; ++b){
            secik.emplace(i*rozmiar+1+a, i*rozmiar+1+b);
        }
    }
    int pierwszy = 0;
    for(int i = 0; i < k; ++i) for(int j = 0; j < i; ++j) if(czy[i][j]){
        for(int xd = 0; xd < wielkosc_bijekcji; ++xd){
            ++licznik[i];
            ++licznik[j];
            secik.emplace(licznik[i], licznik[j]);
            if(!pierwszy){
                pierwszy = 1;
                if(licznik[i] > 1) secik.emplace(licznik[i], rng(1, licznik[i]-1));
                else secik.emplace(rng(licznik[i]+k, n), licznik[i]);
            }
        }
    }

    vector<int> perm(n+1);
    for(int i = 1; i<= n; ++i) perm[i] = i;
    rng.shuffle(1+perm.begin(), perm.end());

    cout << 1 << "\n";
    cout << maks_n << " " << secik.size() << "\n";
    for(auto [a, b] : secik){
        a = perm[a], b = perm[b];
        if(a > b) swap(a, b);
        cout << a << " " << b << "\n";
    }
}

void gen_uwalacz_wolnych_trojkatow(int n, int m, int ile_grubych){
    vector<int> grube;
    for(int i = 1; i <= n; ++i) grube.emplace_back(i);
    rng.shuffle(grube.begin(), grube.end());
    grube.resize(ile_grubych);

    set<pair<int, int>> kraw;
    auto dodaj = [&](int a, int b){
        if(a == b) return 0;
        if(a > b) swap(a, b);
        pair<int, int> para = {a, b};
        if(kraw.count(para)) return 0;
        kraw.emplace(para);
        return 1;
    };

    cout << 1 << "\n";
    cout << n << " " << m << "\n";
    for(int i = 0; i < m; ++i){
        while(1){
            int a = rng(1, n);
            int b = i<4*m/5 ? grube[rng(0, ile_grubych-1)] : rng(1, n);
            if(dodaj(a, b)){
                cout << min(a, b) << " " << max(a, b) << "\n";
                break;
            }
        }
    }
}

void gen_rozlaczne_kliki(int n, int m, int min_roz, int max_roz){
    set<pair<int, int>> kraw;
    auto jest = [&](int a, int b){
        if(a > b) swap(a, b);
        return kraw.count({a, b});
    };
    auto dodaj = [&](int a, int b){
        if(a > b) swap(a, b);
        kraw.emplace(a, b);
    };

    while(1){
        int rozmiar = rng(min_roz, max_roz);
        int odej = rozmiar * (rozmiar-1) / 2;
        m -= odej;
        if(m < 0) break;

        vector<int> wierz;
        while((int)wierz.size() < rozmiar){
            while(1){
                int nowy = rng(1, n);
                int git = 1;
                for(int x : wierz){
                    if(x == nowy) git = 0;
                    if(jest(x, nowy)) git = 0;
                    if(!git) break;
                }
                if(!git) continue;
                for(int x : wierz) dodaj(x, nowy);
                wierz.emplace_back(nowy);
                break;
            }
        }
    }

    cout << 1 << "\n";
    cout << n << " " << kraw.size() << "\n";
    for(auto [a, b] : kraw) cout << a << " " << b << "\n";
}

void gen_cztery_kliki_cykl(int n, int m, int los) {
    vector<int> v1(n);
    iota(v1.begin(), v1.end(), 0);
    vector<int> v2(n);
    iota(v2.begin(), v2.end(), v1.back());
    vector<int> v3(n);
    iota(v3.begin(), v3.end(), v2.back());
    vector<int> v4(n);
    iota(v4.begin(), v4.end(), v3.back());
    v4.back() = 0;

    oi_assert(v4.end()[-2] + 1 == n * 4 - 4);
    int N = n * 4 - 4;

    set<pair<int, int>> kraw;
    auto dodaj = [&](int a, int b){
        if(a > b) swap(a, b);
        kraw.emplace(a, b);
    };

    for (auto v : {v1, v2, v3, v4}) {
        for (int l : v) {
            for (int r : v) {
                if (l != r) {
                    dodaj(l, r);
                }
            }
        }
    }
    for (int i = 0; i < los; ++i) {
        int l = rng(0, N - 1);
        int r = rng(0, N - 1);
        if (l != r) {
            dodaj(l, r);
        }
    }

    oi_assert(ssize(kraw) <= m);
    vector<int> perm(N);
    iota(perm.begin(), perm.end(), 1);
    rng.shuffle(perm);
    cout << 1 << endl;
    cout << N << ' ' << ssize(kraw) << endl;
    for (auto [a, b] : kraw) {
        a = perm[a];
        b = perm[b];
        if (a > b) {
            swap(a, b);
        }
        cout << a << ' ' << b << endl;
    }
}

template<class Func, class... Args>
void gen_test(string test_name, uint_fast64_t seed, Func&& func, Args&&... args);

// If there's no need to set a specific seed, this function will reseed the `rng`
// with a deterministic hash of the `test_name` string.
template<class Func, class... Args>
void gen_test_reseed(string test_name, Func&& func, Args&&... args);

struct Test {
    unsigned group;
    unsigned id;

    operator string();
    Test operator++(int) noexcept;
    void advance_group() noexcept;
};

void gen_all_tests() {
    gen_test_reseed("0", gen_0);
    //gen_test_reseed("1ocen", gen_1ocen);
    //gen_test_reseed("2ocen", gen_2ocen);
    //gen_test_reseed("3ocen", gen_3ocen);
    //gen_test_reseed("4ocen", gen_4ocen);

    //n <= 10
    Test current_test{.group = 1, .id = 0};
    for(int i = 0; i <= 10*(10-1)/2; i += 9)
        gen_test_reseed(current_test++, gen_losowe, 10, i, 10'000, 100'000);

    // m <= 10^4
    current_test.advance_group();
    for(int i = 0; i <= 100*(100-1)/2; i += 10*99)
        gen_test_reseed(current_test++, gen_losowe, 100, i, 100'000, 10'000);
    gen_test_reseed(current_test++, gen_klika, 141);
    gen_test_reseed(current_test++, gen_sloneczko, 10'001);
    gen_test_reseed(current_test++, gen_losowe, 100'000, 10'000, 100'000, 10'000);
    gen_test_reseed(current_test++, gen_losowe, 10'000, 10'000, 100'000, 10'000);
    gen_test_reseed(current_test++, gen_losowe, 1'000, 10'000, 100'000, 10'000);
    for(int i = 2; i <= 10; i += 3)
        gen_test_reseed(current_test++, gen_uwalacz_wolnych_trojkatow, 10'000, 10'000, i);
    gen_test_reseed(current_test++, gen_cztery_kliki, 10'000);

    // n <= 500
    current_test.advance_group();
    gen_test_reseed(current_test++, gen_losowe, 500, 100'000, 500, 100'000);
    gen_test_reseed(current_test++, gen_losowe, 500, 50'000, 500, 100'000);
    gen_test_reseed(current_test++, gen_losowe, 500, 20'000, 500, 100'000);
    gen_test_reseed(current_test++, gen_sloneczko, 500);
    gen_test_reseed(current_test++, gen_klika, 447);
    gen_test_reseed(current_test++, gen_klika_i_diament, 447);
    gen_test_reseed(current_test++, gen_rozlaczne_kliki, 500, 30'000, 5, 12);
    gen_test_reseed(current_test++, gen_rozlaczne_kliki, 500, 40'000, 4, 10);
    gen_test_reseed(current_test++, gen_rozlaczne_kliki, 500, 30'000, 3, 6);
    gen_test_reseed(current_test++, gen_rozlaczne_kliki, 500, 10'000, 2, 7);
    gen_test_reseed(current_test++, gen_rozlaczne_kliki, 500, 10'000, 3, 6);
    gen_test_reseed(current_test++, gen_rozlaczne_kliki, 500, 3'000, 4, 6);
    gen_test_reseed(current_test++, gen_rozlaczne_kliki, 500, 3'000, 3, 7);
    gen_test_reseed(current_test++, gen_cztery_kliki, 31'005);

    // for(int m : {60'000, 50'000, 38'000, 26'000}){
    //     for(int k = 1; k <= 5; ++k){
    //         gen_test_reseed(current_test++, gen_losowy_dwudzielny, 500, m, k);
    //     }
    // }

    for(int i = 0;i < 5; ++i) gen_test_reseed(current_test++, gen_bijekcja_klik, 60'000);
    gen_test_reseed(current_test++, gen_dwie_kliki_dwie_gwiazdki, 60'000);

    {
        auto args = {2, 3, 4, 7, 10};
        for (auto i : args) gen_test_reseed(current_test++, gen_graf_bijekcji_klik, 500, i);
    }

    // bez ogr
    current_test.advance_group();
    gen_test_reseed(current_test++, gen_losowe, 100'000, 100'000, 100'000, 100'000);
    gen_test_reseed(current_test++, gen_losowe, 10'000, 100'000, 100'000, 100'000);
    gen_test_reseed(current_test++, gen_losowe, 1'000, 100'000, 100'000, 100'000);
    gen_test_reseed(current_test++, gen_klika, 447);
    gen_test_reseed(current_test++, gen_sloneczko, 100'000);
    {
        auto args = {2, 3, 4, 7, 10};
        for (auto i : args) gen_test_reseed(current_test++, gen_uwalacz_wolnych_trojkatow, 50'000, 100'000, i);
    }
    // for(int i = 2; i <= 10; ++i)
    //     gen_test_reseed(current_test++, gen_uwalacz_wolnych_trojkatow, 50'000, 100'000, i);

    for(int n = 100'000; n >= 1'000; n = 3*n/8){
        gen_test_reseed(current_test++, gen_rozlaczne_kliki, n, 100'000, 3, 10);
        gen_test_reseed(current_test++, gen_rozlaczne_kliki, n, 100'000, 2, 7);
        gen_test_reseed(current_test++, gen_rozlaczne_kliki, n, 100'000, 4, 8);
    }
    gen_test_reseed(current_test++, gen_cztery_kliki, 100'000);
    gen_test_reseed(current_test++, gen_klika_i_diament, 447);

    // for(int n : {650, 1000, 1700, 3000}){
    //     for(int k = 1; k <= 5; ++k){
    //         gen_test_reseed(current_test++, gen_losowy_dwudzielny, n, 100'000, k);
    //     }
    // }

    for(int i = 0; i < 5; ++i) gen_test_reseed(current_test++, gen_bijekcja_klik, 100'000);
    gen_test_reseed(current_test++, gen_dwie_kliki_dwie_gwiazdki, 100'000);
    {
        auto args = {2, 3, 4, 7, 10};
        for (auto i : args) gen_test_reseed(current_test++, gen_graf_bijekcji_klik, 600, i);
    }

    {
        auto args = {0, 1, 1, 2, 2, 5, 20, 50, 200};
        for (auto i : args) gen_test_reseed(current_test++, gen_cztery_kliki_cykl, 220, 100'000, i);
    }
}

int main(int argc, char* argv[]) {
    if (argc == 3 && string(argv[1]) == "stresstest") {
        // Usage: prog/*ingen stresstest seed_uint64
        rng = oi::Random{static_cast<uint_fast64_t>(stoll(argv[2]))};
        gen_stresstest();
        return 0;
    }
    oi_assert(argc == 1, "Run prog/*ingen.sh to stresstest and create proper tests.");
    gen_all_tests();
    return 0;
}

///////////////////// `Test` and `gen_test_reseed` implementation /////////////////////

const string& get_task_id() {
    static auto task_id = [](string path) {
        auto end = path.rfind("ingen.");
        oi_assert(end != string::npos);
        auto beg = path.rfind('/', end);
        if (beg == string::npos) {
            beg = 0;
        } else {
            ++beg;
        }
        return path.substr(beg, end - beg);
    }(__FILE__);
    return task_id;
}

template<class Func, class... Args>
void gen_test(string test_name, uint_fast64_t seed, Func&& func, Args&&... args) {
    // Flush the buffers before reopening the next test.
    cout << flush;
    fflush(stdout);
    auto test_filename = get_task_id() + test_name + ".in";
    oi_assert(freopen(test_filename.c_str(), "w", stdout), "failed to save test ", test_filename);
    std::cerr << "Generating " << test_filename << "...\n";
    rng = oi::Random{seed};
    func(std::forward<decltype(args)>(args)...);
    // Flush the buffers before giving up control to the caller.
    cout << flush;
    fflush(stdout);
}

template<class Func, class... Args>
void gen_test_reseed(string test_name, Func&& func, Args&&... args) {
    // The new seed is created from the test name.
    uint_fast64_t seed = static_cast<uint_fast64_t>(hash<string_view>{}(test_name));
    gen_test(test_name, seed, func, args...);
}

Test::operator string() {
    string res = "";
    for (;;) {
        res += static_cast<char>('a' + id % ('z' - 'a' + 1));
        if (id <= 'z' - 'a') {
            break;
        }
        id = id / ('z' - 'a' + 1) - 1;
    }
    std::reverse(res.begin(), res.end());
    return to_string(group) + res;
}

Test Test::operator++(int) noexcept {
    Test res = *this;
    ++id;
    return res;
}

void Test::advance_group() noexcept {
    ++group;
    id = 0;
}
