// Waldemar Lamandini
// Złożoność czasowa O(m^1,5), pamięciowa O(m^1,5)
// Rozwiązanie wzorcowe
#include <bits/stdc++.h>
#define FOR(i,p,k) for(int i=(p);i<=(k);++i)
#define REP(i,n) FOR(i,0,(n)-1)
#define all(x) (x).begin(),(x).end()
#define ssize(x) int((x).size())
#define fi first
#define se second
#define V vector
#define pb push_back
#define eb emplace_back
using namespace std;
typedef V<int> vi;
typedef pair<int, int> pii;

int I(){
    int z;
    cin >> z;
    return z;
}

struct fnu{
    vi r, wiel;
    vi czy_ruszone;
    vi ruszone;
    V<vi> listy;
    fnu(int n){
        r.resize(n+1);
        wiel.resize(n+1, 1);
        czy_ruszone.resize(n+1, 0);
        listy.resize(n+1);
        FOR(i, 1, n) r[i] = i;
    }
    int f(int x){
        if(r[x] == x) return x;
        return r[x] = f(r[x]);
    }
    void rusz(int x){
        if(czy_ruszone[x]) return;
        czy_ruszone[x] = 1;
        ruszone.eb(x);
    }
    void u(int a, int b){
        a = f(a), b = f(b);
        if(a == b) return;
        if(wiel[a] < wiel[b]) swap(a, b);
        wiel[a] += wiel[b], r[b] = a;
    }
    V<vi> daj_spojne(){
        V<vi> ret;
        for(int x : ruszone) listy[f(x)].eb(x);
        for(int x : ruszone) if(ssize(listy[x])) ret.eb(listy[x]);
        for(int x : ruszone) listy[x].clear();
        return ret;
    }
    void reset(){
        for(int i : ruszone) czy_ruszone[i] = 0, wiel[i] = 1, r[i] = i;
        ruszone.clear();
    }
};

void answer(){
    int n = I(), m = I();
    vi deg(n+1, 0);
    V<pii> kraw(m);
    REP(i, m){
        int a = I(), b = I();
        kraw[i] = {a, b};
        ++deg[a];
        ++deg[b];
    }

    V<V<pii>> g(n+1);
    V<vi> zbiory(m);
    REP(i, m){
        auto &[a, b] = kraw[i];
        if(deg[a] > deg[b]) swap(a, b);
        g[a].eb(b, i);
    }

    auto trojkat = [&](int a, int b, int c, int ab, int bc, int ca){// wierzcholki na cyklu, nr krawedzi na cyklu
        zbiory[ab].eb(c);
        zbiory[bc].eb(a);
        zbiory[ca].eb(b);
    };

    vi skad(n+1, -1);
    FOR(a, 1, n){
        for(auto [w, i] : g[a]) skad[w] = i;
        for(auto [w, i] : g[a]) for(auto [tmp, j] : g[w]) if(skad[tmp] >= 0) trojkat(a, w, tmp, i, j, skad[tmp]);
        for(auto [w, i] : g[a]) skad[w] = -1;
    }

    V<vi> kub(n+1);
    REP(i, m) for(int x : zbiory[i]) kub[x].eb(i);
    vi usuniety(m, 0);
    REP(i, m) if(ssize(zbiory[i]) < 2) usuniety[i] = 1;

    fnu fnu(n);
    vi sasiad(n+1, 0);
    V<vi> graf(n+1);
    for(auto [a, b] : kraw){
        graf[a].eb(b);
        graf[b].eb(a);
    }

    auto nie_ma_krawedzi = [&](int a, int b){
        REP(nr, m){
            int ile = 0;
            for(int i : zbiory[nr]){
                if(i == a || i == b) ++ile;
            }
            if(ile != 2) continue;
            cout << "YES\n";
            cout << a << " " << b << " " << kraw[nr].fi << " " << kraw[nr].se << "\n";
            return;
        }
        assert(0);
    };

    FOR(lacznik, 1, n){
        vi numerki;
        for(int x : kub[lacznik]) if(!usuniety[x]) numerki.eb(x);

        for(int x : numerki){
            vi zbior = zbiory[x];
            int ost = 0;
            for(int i : zbior) if(i != lacznik){
                fnu.rusz(i);
                if(ost) fnu.u(ost, i);
                ost = i;
            }
            usuniety[x] = 1;
        }

        for(int i : graf[lacznik]) sasiad[i] = 1;

        for(vi zbior : fnu.daj_spojne()){
            for(int i : zbior) if(!sasiad[i]) return nie_ma_krawedzi(lacznik, i);
            int nr = ssize(zbiory);
            zbiory.eb(zbior);
            for(int i : zbior) kub[i].eb(nr);
            usuniety.eb(0);
        }
        fnu.reset();

        for(int i : graf[lacznik]) sasiad[i] = 0;
    }

    cout << "NO\n";
}

int main(){
    int tt = I();
    while(tt--) answer();
}
