#include <iostream>
#include <fstream>
#include <vector>
using namespace std;

#define done(r, m) (cout << r << '\n', cerr << m << '\n', exit(0))

struct point {
	int x, y, z;
};

int main(int argc, const char *argv[]) {
	if (argc != 4) {
		done(0, "Usage: " << argv[0] << " input hint output");
	}

	ifstream in(argv[1]);
	//ifstream hint(argv[2]);
	ifstream out(argv[3]);

	bool partial = false;
	int t; in >> t;
	for (int i = 0; i < t; ++i) {
		int n, k; in >> n >> k;
		vector<point> points(n);
		for (auto & p : points) {
			in >> p.x >> p.y >> p.z;
		}

		int x1, y1, z1, x2, y2, z2;
		out >> x1 >> y1 >> z1 >> x2 >> y2 >> z2;
		if (!out) done(0, "Invalid format");
		if (0 > x1 or x1 > x2 or x2 > 1e9) done(0, "Wrong answer");
		if (0 > y1 or y1 > y2 or y2 > 1e9) done(0, "Wrong answer");
		if (0 > z1 or z1 > z2 or z2 > 1e9) done(0, "Wrong answer");
		int c = 0;
		for (const auto & p : points) {
			if (x1 > p.x or p.x > x2) continue;
			if (y1 > p.y or p.y > y2) continue;
			if (z1 > p.z or p.z > z2) continue;
			c += 1;
		}
		if (c < k) done(0, "Wrong answer");
		if (c > 3 * k) done(0, "Wrong answer");
		if (c > (3 * k + 1) / 2) partial = true;
	}

	char c; out >> c;
	if (out) done(0, "Invalid format");
	done((partial ? 0.25 : 1.0), "OK");
}
