#!/usr/bin/env python3

# Input validator

import sys

st = set(range(1, 9))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

t = int(fi.readline().strip())
print(t, file=fo)
if len(sys.argv) > 4 and sys.argv[4].startswith('-vv'):
    print(t)
if t > 50:
    st.discard(3)
    st.discard(4)
    st.discard(5)
    st.discard(6)
    st.discard(7)
    st.discard(8)
if t > 50000:
    sys.exit(f'T out of range')

sn = 0
for i in range(t):
    n, k = (int(v) for v in fi.readline().split())
    if 2 > n:
        sys.exit(f'N[{1+i}] out of range')
    if 2 > k or k > n:
        sys.exit(f'K[{1+i}] out of range')
    print(n, k, file=fo)
    sn += n
    if n > 10:
        st.discard(1)
        st.discard(2)

    xyz = set()
    for j in range(n):
        x, y, z = (int(v) for v in fi.readline().split())
        if 0 > x or x > 1e9:
            sys.exit(f'X[{1+i},{1+j}] out of range')
        if 0 > y or y > 1e9:
            sys.exit(f'Y[{1+i},{1+j}] out of range')
        if 0 > z or z > 1e9:
            sys.exit(f'Z[{1+i},{1+j}] out of range')
        if (x, y, z) in xyz:
            sys.exit(f'duplicate XYZ[{1+i},{1+j}]')
        xyz.add((x, y, z))
        print(x, y, z, file=fo)
        if z > 0:
            st.discard(1)
            st.discard(3)
            st.discard(5)
            st.discard(7)

if sn > 200:
    st.discard(3)
    st.discard(4)
if sn > 5_000:
    st.discard(5)
    st.discard(6)
if sn > 500_000:
    sys.exit(f'SN out of range')

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
