#include "oi.h"
#undef cout
#undef printf
#include <bits/stdc++.h>
using namespace std;

oi::Random rng;

using P = array<int, 3>; // {x, y, z}
using TestCase = pair<int, vector<P>>; // {k, points}
using FullTest = vector<TestCase>; // test cases

auto&operator<<(ostream&o, const FullTest& test) {
    o << ssize(test) << '\n';
    for (const auto& [k, points] : test) {
        o << ssize(points) << ' ' << k << '\n';
        for (const auto& [x, y, z] : points) {
            cout << x << ' ' << y << ' ' << z << '\n';
        }
    }
    return o;
}

void set_k(TestCase& test, int k) {
    test.first = k;
}

TestCase gen_random_testcase(int min_n, int max_n, int max_range, bool z_zero) {
    const int n = rng(max(3, min_n), max_n);
    const int k = rng(2, n - 1);
    const int min_range = z_zero ? int(ceil(pow(n, 1.0/2.0)) - 1) : int(ceil(pow(n, 1.0/3.0)) - 1);
    const int range = rng(min_range, max_range);
    set<P> s;
    while (ssize(s) < n) {
        s.emplace(P{rng(0, range), rng(0, range), z_zero ? 0 : rng(0, range)});
    }
    vector<P> points(s.begin(), s.end());
    rng.shuffle(points);
    return {k, points};
}

void gen_random_test(int t, int min_n, int max_n, int max_range, bool z_zero) {
    FullTest test;
    while (t --> 0) {
        test.emplace_back(gen_random_testcase(min_n, max_n, max_range, z_zero));
    }
    cout << test;
}

// żadne dwa punkty nie leżą na całkowitoliczbowej prostej równoległej do żadnej z 3 osi.
void gen_test_anti_plane_k_3k2(int max_n, bool z_zero) {
    FullTest test;

    const int K = 2, PTS_PER_SIDE = K * 3 + 1;
    
    const int Y_MAGIC = 11, Z_MAGIC = 201;
    vector<P> x, y, z; // y - punkty z $y$ = 0, itp.
    for (int i = 0; i < PTS_PER_SIDE; i++) {
        x.push_back(P{0, i + 1, (i + 1) * (i + 1)});
        y.push_back(P{i + Y_MAGIC, 0, (i + Y_MAGIC) * (i + Y_MAGIC)});
        z.push_back(P{i + Z_MAGIC, (i + Z_MAGIC) * (i + Z_MAGIC), 0});
    }
    if (!z_zero) {
        test.push_back({K, x});
        test.push_back({K, y});
        if (max_n > 3 * PTS_PER_SIDE) {
            auto pts = x;
            pts.insert(pts.end(), y.begin(), y.end());
            pts.insert(pts.end(), z.begin(), z.end());
            test.push_back({K, pts});
        }
    } 
    test.push_back({K, z});
    cout << test;
}

void gen_test_box(bool z_zero) {
    FullTest test;

    const int K = 6, PTS_PER_SIDE = K - 1;
    
    int z_max = z_zero ? 1 : PTS_PER_SIDE;
    vector<P> pts;
    for (int z = 0; z < z_max; z++) {
        for (int x = 0; x < PTS_PER_SIDE; x++) {
            for(int y = 0; y < PTS_PER_SIDE; y++) {
                pts.push_back(P{x, y, z});
            }
        }
    }
    test.push_back({K, pts});
    cout << test;
}

vector<int> split_at_least_3(int sum_n, int t) {
    oi_assert(3 * t <= sum_n);
    sum_n -= 3 * t;
    vector<int> points = {0, sum_n};
    for (int i = 0; i < t - 1; ++i) {
        points.emplace_back(rng(0, sum_n));
    }
    sort(points.begin(), points.end());
    vector<int> ret;
    for (int i = 0; i < t; ++i) {
        ret.emplace_back(3 + points[i + 1] - points[i]);
    }
    return ret;
}

void gen_random_test_sum(int t, int min_sum_n, int max_sum_n, int max_range, bool z_zero) {
    FullTest test;
    const int sum_n = rng(min_sum_n, max_sum_n);
    for (auto n : split_at_least_3(sum_n, t)) {
        test.emplace_back(gen_random_testcase(n, n, max_range, z_zero));
    }
    cout << test;
}

TestCase gen_cross_testcase(int n, int max_range, bool z_zero) {
    const int k = clamp(z_zero ? n / 4 + 10 : n / 6 + 10, 2, n - 1);
    P middle = {max_range / 2, max_range / 2, z_zero ? 0 : max_range / 2};
    set<P> s = {middle};
    while (ssize(s) < n) {
        P p = middle;
        p[rng(0, 2 - z_zero)] = rng(0, max_range);
        s.emplace(p);
    }
    vector<P> points(s.begin(), s.end());
    rng.shuffle(points);
    return {k, points};
}

void gen_cross_test_sum(int t, int min_sum_n, int max_sum_n, int max_range, bool z_zero) {
    FullTest test;
    const int sum_n = rng(min_sum_n, max_sum_n);
    for (auto n : split_at_least_3(sum_n, t)) {
        test.emplace_back(gen_cross_testcase(n, max_range, z_zero));
    }
    cout << test;
}

// Change this function to generate one test for stresstesting.
// The script prog/abcingen.sh in 10 seconds generates as much tests as possible
// and compares the outputs of the model solution and brute solution.
// The tests shouldn't be very big, but should be able to cover edge cases.
void gen_stresstest() {
    const int max_range = rng(0, 1) ? 10 : 1000;
    gen_random_test(10, 1, 10, max_range, rng(0, 1));
}

void gen_0() {
    cout << R"(4
4 3
1 2 1
0 0 2
3 3 3
2 1 0
5 3
3 0 0
3 2 0
3 3 0
3 5 0
3 6 0
7 6
6 0 0
6 1 0
6 2 0
6 3 0
7 0 0
7 1 0
7 3 0
10 7
0 0 0
0 0 2
0 2 0
0 2 2
1 1 1
2 0 0
2 0 2
2 2 0
2 2 2
3 1 1
)";
}

void gen_1ocen() {
    TestCase test;
    set_k(test, 5);
    for (int x : {0, 1})
        for (int y : {0, 1})
            for (int z : {0, 1})
                test.second.emplace_back(P{x, y, z});
    cout << FullTest{test};
}

void gen_2ocen() {
    const int n = 100;
    const int k = 10;
    TestCase test;
    set_k(test, k);
    for (int i = 1; i <= n; ++i) {
        test.second.emplace_back(P{i, 0, 0});
    }
    cout << FullTest{test};
}

void gen_3ocen() {
    const int n = 900;
    const int k = 100;
    TestCase test;
    set_k(test, k);
    for (int i = 1; i <= n; ++i) {
        test.second.emplace_back(P{i, i, i});
    }
    cout << FullTest{test};
}

void gen_4ocen() {
    const int n = 500'000;
    const int k = 100'000;
    TestCase test;
    set_k(test, k);
    for (int i = 1; i <= n; ++i) {
        test.second.emplace_back(P{i % 101, i % 51, i % 113});
    }
    cout << FullTest{test};
}

template<class Func, class... Args>
void gen_test(string test_name, uint_fast64_t seed, Func&& func, Args&&... args);

// If there's no need to set a specific seed, this function will reseed the `rng`
// with a deterministic hash of the `test_name` string.
template<class Func, class... Args>
void gen_test_reseed(string test_name, Func&& func, Args&&... args);

struct Test {
    unsigned group;
    unsigned id;

    operator string();
    Test operator++(int) noexcept;
    void advance_group() noexcept;
};

void gen_all_tests() {
    gen_test_reseed("0", gen_0);
    //gen_test_reseed("1ocen", gen_1ocen);
    //gen_test_reseed("2ocen", gen_2ocen);
    //gen_test_reseed("3ocen", gen_3ocen);
    //gen_test_reseed("4ocen", gen_4ocen);

    Test current_test{.group = 1, .id = 0};
    {
        const int max_t = 50'000;
        const int max_n = 10;
        const int max_range = int(1e9);

        const auto common_tests = [&](bool zero_z) {
            for (int i = 0; i < 3; ++i) {
                gen_test_reseed(current_test++, gen_random_test, max_t, max_n, max_n, max_range, zero_z);
            }
            for (int i = 0; i < 5; ++i) {
                gen_test_reseed(current_test++, gen_random_test, max_t, max_n, max_n, 3 + 2 * i, zero_z);
            }
            gen_test_reseed(current_test++, gen_test_anti_plane_k_3k2, max_n, zero_z);
        };

        common_tests(false);

        current_test.advance_group();

        common_tests(true);
    }

    current_test.advance_group();
    {
        const int max_t = 50;
        const int max_n = 200;
        const int max_sum_n = max_n;
        const int max_range = int(1e9);

        const auto common_tests = [&](bool zero_z) {
            for (int i = 0; i < 3; ++i) {
                gen_test_reseed(current_test++, gen_random_test, 1, max_n, max_n, max_range, zero_z);
            }
            gen_test_reseed(current_test++, gen_random_test_sum, max_t, max_sum_n, max_sum_n, max_range, zero_z);
            for (int i = 0; i < 5; ++i) {
                gen_test_reseed(current_test++, gen_cross_test_sum, 1, max_sum_n - i * 20, max_sum_n, max_range, zero_z);
            }
            for (int i = 0; i < 3; ++i) {
                gen_test_reseed(current_test++, gen_cross_test_sum, 10, max_sum_n, max_sum_n, max_range, zero_z);
            }
            gen_test_reseed(current_test++, gen_test_anti_plane_k_3k2, max_n, zero_z);
            gen_test_reseed(current_test++, gen_test_box, zero_z);
        };

        common_tests(false);

        current_test.advance_group();

        common_tests(true);
    }

    current_test.advance_group();
    {
        const int max_t = 50;
        const int max_n = 5000;
        const int max_sum_n = max_n;
        const int max_range = int(1e9);

        const auto common_tests = [&](bool zero_z) {
            for (int i = 0; i < 3; ++i) {
                gen_test_reseed(current_test++, gen_random_test, 1, max_n, max_n, max_range, zero_z);
            }
            gen_test_reseed(current_test++, gen_random_test_sum, max_t, max_sum_n, max_sum_n, max_range, zero_z);
            for (int i = 0; i < 5; ++i) {
                gen_test_reseed(current_test++, gen_cross_test_sum, 1, max_sum_n - i * 20, max_sum_n, max_range, zero_z);
            }
            for (int i = 0; i < 3; ++i) {
                gen_test_reseed(current_test++, gen_cross_test_sum, 10, max_sum_n, max_sum_n, max_range, zero_z);
            }
            gen_test_reseed(current_test++, gen_test_anti_plane_k_3k2, max_n, zero_z);
            gen_test_reseed(current_test++, gen_test_box, zero_z);
        };

        common_tests(false);
        for (int i = 0; i < 3; ++i) {
            gen_test_reseed(current_test++, gen_cross_test_sum, 1, max_sum_n - i * 20, max_sum_n, max_range, true);
        }

        current_test.advance_group();

        common_tests(true);
    }

    current_test.advance_group();
    {
        const int max_t = 50;
        const int max_n = 500'000;
        const int max_sum_n = max_n;
        const int max_range = int(1e9);

        const auto common_tests = [&](bool zero_z) {
            for (int i = 0; i < 3; ++i) {
                gen_test_reseed(current_test++, gen_random_test, 1, max_n, max_n, max_range, zero_z);
            }
            gen_test_reseed(current_test++, gen_random_test_sum, max_t, max_sum_n, max_sum_n, max_range, zero_z);
            for (int i = 0; i < 5; ++i) {
                gen_test_reseed(current_test++, gen_cross_test_sum, 1, max_sum_n - i * 20, max_sum_n, max_range, zero_z);
            }
            for (int i = 0; i < 3; ++i) {
                gen_test_reseed(current_test++, gen_cross_test_sum, 10, max_sum_n, max_sum_n, max_range, zero_z);
            }
            gen_test_reseed(current_test++, gen_test_anti_plane_k_3k2, max_n, zero_z);
            gen_test_reseed(current_test++, gen_test_box, zero_z);
        };

        common_tests(false);

        current_test.advance_group();

        common_tests(true);
    }
}

int main(int argc, char* argv[]) {
    if (argc == 3 && string(argv[1]) == "stresstest") {
        // Usage: prog/*ingen stresstest seed_uint64
        rng = oi::Random{static_cast<uint_fast64_t>(stoll(argv[2]))};
        gen_stresstest();
        return 0;
    }
    oi_assert(argc == 1, "Run prog/*ingen.sh to stresstest and create proper tests.");
    gen_all_tests();
    return 0;
}

///////////////////// `Test` and `gen_test_reseed` implementation /////////////////////

const string& get_task_id() {
    static auto task_id = [](string path) {
        auto end = path.rfind("ingen.");
        oi_assert(end != string::npos);
        auto beg = path.rfind('/', end);
        if (beg == string::npos) {
            beg = 0;
        } else {
            ++beg;
        }
        return path.substr(beg, end - beg);
    }(__FILE__);
    return task_id;
}

template<class Func, class... Args>
void gen_test(string test_name, uint_fast64_t seed, Func&& func, Args&&... args) {
    // Flush the buffers before reopening the next test.
    cout << flush;
    fflush(stdout);
    auto test_filename = get_task_id() + test_name + ".in";
    oi_assert(freopen(test_filename.c_str(), "w", stdout), "failed to save test ", test_filename);
    std::cerr << "Generating " << test_filename << "...\n";
    rng = oi::Random{seed};
    func(std::forward<decltype(args)>(args)...);
    // Flush the buffers before giving up control to the caller.
    cout << flush;
    fflush(stdout);
}

template<class Func, class... Args>
void gen_test_reseed(string test_name, Func&& func, Args&&... args) {
    // The new seed is created from the test name.
    uint_fast64_t seed = static_cast<uint_fast64_t>(hash<string_view>{}(test_name));
    gen_test(test_name, seed, func, args...);
}

Test::operator string() {
    string res = "";
    for (;;) {
        res += static_cast<char>('a' + id % ('z' - 'a' + 1));
        if (id <= 'z' - 'a') {
            break;
        }
        id = id / ('z' - 'a' + 1) - 1;
    }
    std::reverse(res.begin(), res.end());
    return to_string(group) + res;
}

Test Test::operator++(int) noexcept {
    Test res = *this;
    ++id;
    return res;
}

void Test::advance_group() noexcept {
    ++group;
    id = 0;
}
