// Arkadiusz Czarkowski
// Złożoność czasowa O(n log n), pamięciowa O(n).
// Rozwiązanie wzorcowe.
#include <bits/stdc++.h>
using namespace std;

const int INF = 1e9;

using P = array<int, 3>;
template<size_t id>
const auto cmp = [](P a, P b) {
    return a[id] < b[id];
};
template<size_t id>
const auto full_cmp = [](P a, P b) {
    return cmp<id>(a, b) or (not cmp<id>(b, a) and a < b);
};

void solve() {
    int n, k;
    cin >> n >> k;
    vector<P> points(n);
    for (auto& [x, y, z] : points) {
        cin >> x >> y >> z;
    }

    set<P, decltype(full_cmp<0>)> s0(full_cmp<0>);
    set<P, decltype(full_cmp<1>)> s1(full_cmp<1>);
    set<P, decltype(full_cmp<2>)> s2(full_cmp<2>);

    auto add = [&](P x) {
        s0.emplace(x);
        s1.emplace(x);
        s2.emplace(x);
    };
    auto erase = [&](P x) {
        s0.erase(x);
        s1.erase(x);
        s2.erase(x);
    };

    for (auto p : points)
        add(p);

    const int limit = (3 * k + 1) / 2;
    while (ssize(s0) > limit) {
        auto i0 = s0.begin();
        auto i1 = s1.begin();
        auto i2 = s2.begin();
        auto i0r = prev(s0.end());
        auto i1r = prev(s1.end());
        auto i2r = prev(s2.end());
        while (not cmp<0>(*s0.begin(), *i0) and
               not cmp<1>(*s1.begin(), *i1) and
               not cmp<2>(*s2.begin(), *i2) and
               not cmp<0>(*i0r, *prev(s0.end())) and
               not cmp<1>(*i1r, *prev(s1.end())) and
               not cmp<2>(*i2r, *prev(s2.end()))
              ) {
            ++i0;
            ++i1;
            ++i2;
            --i0r;
            --i1r;
            --i2r;
        }
        vector<P> to_be_deleted;
        if (cmp<0>(*s0.begin(), *i0)) {
            to_be_deleted = {s0.begin(), i0};
        }
        else if (cmp<1>(*s1.begin(), *i1)) {
            to_be_deleted = {s1.begin(), i1};
        }
        else if (cmp<2>(*s2.begin(), *i2)) {
            to_be_deleted = {s2.begin(), i2};
        }
        else if (cmp<0>(*i0r, *prev(s0.end()))) {
            to_be_deleted = {next(i0r), s0.end()};
        }
        else if (cmp<1>(*i1r, *prev(s1.end()))) {
            to_be_deleted = {next(i1r), s1.end()};
        }
        else if (cmp<2>(*i2r, *prev(s2.end()))) {
            to_be_deleted = {next(i2r), s2.end()};
        }
        else {
            assert(false);
        }
        for (auto p : to_be_deleted)
            erase(p);
    }
    assert(ssize(s0) >= k);

    P lower = {INF, INF, INF};
    P upper = {0, 0, 0};
    for (auto p : s0) {
        for (int i = 0; i < 3; ++i) {
            lower[i] = min(lower[i], p[i]);
            upper[i] = max(upper[i], p[i]);
        }
    }
    for (int i = 0; i < 3; ++i) {
        cout << lower[i] << ' ';
    }
    for (int i = 0; i < 3; ++i) {
        cout << upper[i] << (i == 2 ? '\n' : ' ');
    }
}

int main() {
    //cin.tie(0)->sync_with_stdio(0);

    int t;
    cin >> t;
    while (t --> 0) {
        solve();
    }
}
