// Marcin Mordecki
// Złożoność czasowa O(n log n), pamięciowa O(n).
// Rozwiązanie wzorcowe.
#include <bits/stdc++.h>
using namespace std;

struct pt {
    int x, y, z;
    pt(int _x, int _y, int _z): x(_x), y(_y), z(_z) {}
};

const int BIG_COORD = 1e9 + 7, SMALL_COORD = -1;

void solve(void) {
    int n, k;
    cin >> n >> k;

    const int K2 = (3 * k + 1) / 2;
    vector<pt> pts;

    using planes_map = map<int, set<int>>;
    planes_map px, py, pz;
    
    int minx = BIG_COORD, miny = BIG_COORD, minz = BIG_COORD, maxx = SMALL_COORD, maxy = SMALL_COORD, maxz = SMALL_COORD;

    for (int i = 0; i < n; i++) {
        int x, y, z;
        cin >> x >> y >> z;
        // every point gets unique color (equal to the iteration number $i$), so planes_maps store integers.
        pts.emplace_back(pt(x, y, z));
        px[x].insert(i);
        py[y].insert(i);
        pz[z].insert(i);

        minx = min(minx, x);
        miny = min(miny, y);
        minz = min(minz, z);
        maxx = max(maxx, x);
        maxy = max(maxy, y);
        maxz = max(maxz, z);
    }

    while (n >= k) {
        if (n <= K2) {
            cout << minx << ' ' << miny << ' ' << minz << ' ' << maxx << ' ' << maxy << ' ' << maxz << '\n';
            return;
        }

        int which_side = 2, sizee = (int)px[minx].size(), side_coord = minx;
        /*
        minx - 2
        maxx - 3
        miny - 4
        maxy - 5
        minz - 8
        maxz - 9
        planes_map X - which_side & 2 != 0
        planes_map Y - which_side & 4 != 0
        planes_map Z - which_side & 8 != 0
        */
        auto check = [&](planes_map &p, int coord, int swtch) {
            if (sizee > (int)p[coord].size()) {
                sizee = (int)p[coord].size();
                which_side = swtch;
                side_coord = coord;
            }
        };

        check(px, maxx, 3);
        check(py, miny, 4);
        check(py, maxy, 5);
        check(pz, minz, 8);
        check(pz, maxz, 9);

        planes_map &p = (which_side & 2) ? px : (which_side & 4) ? py : pz;
        
        for (auto color : p[side_coord]) {
            auto coords = pts[color];
            // DO NOT remove from the map you're iterating on; otherwise iterators will blow up.
            if (!(which_side & 2))
                px[coords.x].erase(px[coords.x].find(color));
            if (!(which_side & 4))
                py[coords.y].erase(py[coords.y].find(color));
            if (!(which_side & 8))
                pz[coords.z].erase(pz[coords.z].find(color));
            --n;
        }

        // clear the chosen side
        p[side_coord].clear();
        p.erase(p.find(side_coord));
    
        // select next side to the cleared one.
        if (which_side == 2)
            minx = px.begin()->first;
        if (which_side == 3) 
            maxx = px.rbegin()->first;
        if (which_side == 4)
            miny = py.begin()->first;
        if (which_side == 5)
            maxy = py.rbegin()->first;  
        if (which_side == 8)
            minz = pz.begin()->first;
        if (which_side == 9)
            maxz = pz.rbegin()->first;
    }

}

int main() {
    int t;
    cin >> t;
    while (t--) {
        solve();
    }
}
