#include "oi.h"
#undef cout
#undef printf
#include <bits/stdc++.h>
using namespace std;

oi::Random rng;
oi::Random rng_ocen(16);

// Change this function to generate one test for stresstesting.
// The script prog/abcingen.sh in 10 seconds generates as much tests as possible
// and compares the outputs of the model solution and brute solution.
// The tests shouldn't be very big, but should be able to cover edge cases.
void gen_stresstest() {
    int n = rng(3, 6);
    int m = rng(n / 3, n);
    cout << n << " " << m << "\n";
    for (int i = 0; i < n; i++) {
        cout << rng(1, 15) << (i == n - 1 ? '\n' : ' ');
    }
    vector<pair<int, pair<int, int>>> qs;
    for(int i = 0; i < m; i++) {
        int t = rng(1, 2);
        int x = rng(1, n);
        int y = rng(1, n);
        qs.emplace_back(t, make_pair(x, y));
    }
    for (auto [t, p] : qs) {
        cout << t << " " << p.first << " " << p.second << "\n";
    }
}

void gen_0() {
    cout << "5 5\n";
    cout << "1 2 3 5 4\n";
    cout << "1 1 3\n";
    cout << "2 1 4\n";
    cout << "1 4 5\n";
    cout << "2 5 4\n";
    cout << "1 5 2\n";
}

bool isPrime(int n) {
    if (n <= 1) return false;
    if (n == 2) return true;
    if (n % 2 == 0) return false;

    for (int i = 3; i * i <= n; i += 2) {
        if (n % i == 0) return false;
    }
    return true;
}

void gen_1_ocen() {
    cout << "10 8\n";
    cout << "1 2 3 4 5 6 7 8 9 10\n";
    vector<int> primes = {2, 3, 5, 7};
    vector<int> non_primes = {1, 4, 6, 8, 9, 10};

    for (int i = 1; i < (int) primes.size(); i++) {
        cout << "1 " << primes[i - 1] << " " << primes[i] << "\n";
    }
    for (int i = 1; i < (int) non_primes.size(); i++) {
        cout << "2 " << non_primes[i - 1] << " " << non_primes[i] << "\n";
    }
}

void gen_2_ocen() {
    int n = 100;
    cout << "100 197\n";
    for (int i = 1; i <= 100; i++) {
        if (isPrime(i)) {
            cout << i << (i == n ? '\n' : ' ');
        } else {
            cout << 101 - i << (i == n ? '\n' : ' ');
        }
    }

    for (int i = 2; i <= 100; i++) {
        cout << "1 " << i << " " << i - 1 << "\n";
    }

    for (int i = 1; i <= 98; i++) {
        cout << "2 " << i << " " << i + 2 << "\n";
    }
}

void gen_3_ocen() {
    int n = 100000;
    cout << "100000 99999\n";
    for (int i = 1; i <= 100000; i++) {
        cout << 1 + i % 7 << (i == n ? '\n' : ' ');
    }

    for (int i = 1; i <= 99999; i++) {
        cout << "2 " << i << " " << i + 1 << "\n";
    }
}

void gen_4_ocen() {
    int n = 500'000;
    int m = 0;
    long long val = 1'000'000;

    cout << n << " " << m << "\n";
    for (int i = 1; i <= n; i++) {
        cout << val << (i == n ? '\n' : ' ');
    }
}

void gen_force_ll(int n, int m) {
    cout << n << " " << m << "\n";
    for (int i = 0; i < n; i++) {
        cout << rng(9'000'000'00, 1'000'000'000) << (i == n - 1 ? '\n' : ' ');
    }
    for (int i = 0; i < m; i++) {
        int t = rng(1, 2);
        int a = rng(1, n);
        int b = rng(1, n - 1);
        if (b >= a) b++;
        cout << t << " " << a << " " << b << "\n";
    }
}

void gen_super_low_variance_test(int n, int m) {
    /* The Idea is that this counters 'checking just a few elements' */
    cout << n << " " << m << "\n";
    for (int i = 0; i < n; i++) {
        cout << rng(100, 130) << (i == n - 1 ? '\n' : ' ');
    }
    for (int i = 0; i < m; i++) {
        int t = rng(1, 2);
        int a = rng(1, n);
        int b = rng(1, n - 1);
        if (b >= a) b++;
        cout << t << " " << a << " " << b << "\n";
    }
}

void gen_random_test(int n) {
    /* n <= 50'000 */
    int m = (n - 10) * 4;
    assert(m <= 200'000);
    cout << n << " " << m << "\n";
    for (int i = 0; i < n; i++) {
        cout << rng(1'000'000, 1'000'000'000) << (i == n - 1 ? '\n' : ' ');
    }
    for (int i = 5; i < n - 5; i++) {
        cout << 1 << " " << i << " " << rng(1, i - 1) << "\n";
        cout << 1 << " " << i << " " << rng(i + 1, n) << "\n";
        cout << 2 << " " << i << " " << rng(1, i - 1) << "\n";
        cout << 2 << " " << i << " " << rng(i + 1, n) << "\n";
    }
}

void gen_random_window_test(int n) {
    /* n <= 50'000 */
    int m = (n - 10) * 4;
    assert(m <= 200'000);
    cout << n << " " << m << "\n";
    for (int i = 0; i < n; i++) {
        cout << rng(1'000'000, 1'000'000'000) << (i == n - 1 ? '\n' : ' ');
    }
    for (int i = 5; i < n - 5; i++) {
        cout << 1 << " " << i << " " << rng(max(1, i - 100), i - 1) << "\n";
        cout << 1 << " " << i << " " << rng(min(n, i + 100), n) << "\n";
        cout << 2 << " " << i << " " << rng(max(1, i - 100), i - 1) << "\n";
        cout << 2 << " " << i << " " << rng(min(n, i + 100), n) << "\n";
    }
}

void gen_corner_case(int n) {
    cout << n << ' ' << 3 << '\n';
    cout << 100'000 << ' ' << 99'999 << ' ';
    
    for (int i = 2; i < n - 1; i++) {
        cout << 1 << ' ';
    }
    cout << 100'100 << '\n';

    cout << "1 1 2\n";
    cout << "2 1 3\n";
    cout << "1 " << n << ' ' << 2 << '\n';
}

void gen_low_dist(int n, int m) {
    cout << n << " " << m << "\n";
    for (int i = 0; i < n; i++) {
        cout << rng(100, 100000) << (i == n - 1 ? '\n' : ' ');
    }
    for (int i = 0; i < m; i++) {
        int a = rng(2, n - 1);
        int b = a + 1 - 2 * rng(0, 1);
        cout << rng(1, 2) << " " << a << " " << b << "\n";
    }
}

void gen_completely_random(int n){
    if(n == 1){
        cout << "1 0\n";
        cout << rng(1, 1'000'000'000) << "\n";
        return;
    }

    int m = 2 * n;
    assert(m <= 200'000);
    vector<pair<int, pair<int, int>>> qs;
    vector<int> vals(n+1);
    for(int i = 1; i <= n; i++){
        vals[i] = rng(1, 1'000'000'000);
        int val = rng(1, n - 1);
        if(val >= i) val++;
        qs.push_back({1, {i, val}});
        val = rng(1, n - 1);
        if(val >= i) val++;
        qs.push_back({2, {i, val}});
    }

    cout << n << " " << m << "\n";
    for(int i = 1; i <= n; i++){
        cout << vals[i] << (i == n ? '\n' : ' ');
    }
    for(auto [t, p] : qs){
        cout << t << " " << p.first << " " << p.second << "\n";
    }
}


template<class Func, class... Args>
void gen_test(string test_name, uint_fast64_t seed, Func&& func, Args&&... args);

// If there's no need to set a specific seed, this function will reseed the `rng`
// with a deterministic hash of the `test_name` string.
template<class Func, class... Args>
void gen_test_reseed(string test_name, Func&& func, Args&&... args);

struct Test {
    unsigned group;
    unsigned id;

    operator string();
    Test operator++(int) noexcept;
    void advance_group() noexcept;
};

void gen_all_tests() {
    Test current_test{ .group = 0, .id = 0 };
    gen_test_reseed("0", gen_0);
    //gen_test_reseed("1ocen", gen_1_ocen);
    //gen_test_reseed("2ocen", gen_2_ocen);
    //gen_test_reseed("3ocen", gen_3_ocen);
    //gen_test_reseed("4ocen", gen_4_ocen);

    /* Grupa 1 -> n <= 10 */
    current_test.advance_group();
    gen_test_reseed(current_test++, gen_force_ll, 10, 5);
    gen_test_reseed(current_test++, gen_force_ll, 10, 10);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 10, 5);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 10, 10);
    gen_test_reseed(current_test++, gen_corner_case, 10);
    for(int i = 1; i <= 10; i++){
        gen_test_reseed(current_test++, gen_completely_random, i);
    }

    /* Grupa 2 -> n <= 100 */ 
    current_test.advance_group();
    gen_test_reseed(current_test++, gen_force_ll, 100, 50);
    gen_test_reseed(current_test++, gen_force_ll, 100, 100);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 100, 50);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 100, 100);
    gen_test_reseed(current_test++, gen_random_test, 80);
    gen_test_reseed(current_test++, gen_random_test, 100);
    gen_test_reseed(current_test++, gen_random_window_test, 80);
    gen_test_reseed(current_test++, gen_random_window_test, 100);
    gen_test_reseed(current_test++, gen_corner_case, 100);
    for(int i = 2; i <= 100; i+=9){
        gen_test_reseed(current_test++, gen_completely_random, i);
    }

    /* Grupa 3 -> |a-b| == 1 */
    current_test.advance_group();
    gen_test_reseed(current_test++, gen_low_dist, 10, 10);
    gen_test_reseed(current_test++, gen_low_dist, 100, 100);
    gen_test_reseed(current_test++, gen_low_dist, 1'000, 1'000);
    gen_test_reseed(current_test++, gen_low_dist, 10'000, 10'000);
    gen_test_reseed(current_test++, gen_low_dist, 100'000, 100'000);
    gen_test_reseed(current_test++, gen_low_dist, 200'000, 200'000);
    for(int i = 1; i <= 5; i++){
        gen_test_reseed(current_test++, gen_low_dist, 200'000, 200'000);
    }

    /* Grupa 4 -> n <= 5'000 */
    current_test.advance_group();
    gen_test_reseed(current_test++, gen_force_ll, 5'000, 50);
    gen_test_reseed(current_test++, gen_force_ll, 5'000, 500);
    gen_test_reseed(current_test++, gen_force_ll, 5'000, 1'000);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 5'000, 50);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 5'000, 500);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 5'000, 5'000);
    gen_test_reseed(current_test++, gen_random_test, 400);
    gen_test_reseed(current_test++, gen_random_test, 4'000);
    gen_test_reseed(current_test++, gen_random_test, 5'000);
    gen_test_reseed(current_test++, gen_random_window_test, 400);
    gen_test_reseed(current_test++, gen_random_window_test, 4'000);
    gen_test_reseed(current_test++, gen_random_window_test, 5'000);
    gen_test_reseed(current_test++, gen_corner_case, 5'000);
    for(int i = 2; i <= 5'000; i+=999){
        gen_test_reseed(current_test++, gen_completely_random, i);
    }

    /* Grupa 5 -> n <= 200'000 */
    current_test.advance_group();
    gen_test_reseed(current_test++, gen_force_ll, 200'000, 50'000);
    gen_test_reseed(current_test++, gen_force_ll, 200'000, 100'000);
    gen_test_reseed(current_test++, gen_force_ll, 200'000, 200'000);
    gen_test_reseed(current_test++, gen_force_ll, 200'000, 200'000);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 200'000, 500);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 200'000, 1'000);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 200'000, 10'000);
    gen_test_reseed(current_test++, gen_super_low_variance_test, 200'000, 200'000);
    gen_test_reseed(current_test++, gen_random_test, 25'000);
    gen_test_reseed(current_test++, gen_random_test, 50'000);
    gen_test_reseed(current_test++, gen_random_test, 50'000);
    gen_test_reseed(current_test++, gen_random_window_test, 25'000);
    gen_test_reseed(current_test++, gen_random_window_test, 50'000);
    gen_test_reseed(current_test++, gen_random_window_test, 50'000);
    gen_test_reseed(current_test++, gen_corner_case, 200'000);
    for(int i = 2; i <= 100'000; i+=49'999){
        gen_test_reseed(current_test++, gen_completely_random, i);
    }
}

int main(int argc, char* argv[]) {
    if (argc == 3 && string(argv[1]) == "stresstest") {
        // Usage: prog/*ingen stresstest seed_uint64
        rng = oi::Random{static_cast<uint_fast64_t>(stoll(argv[2]))};
        gen_stresstest();
        return 0;
    }
    oi_assert(argc == 1, "Run prog/*ingen.sh to stresstest and create proper tests.");
    gen_all_tests();
    return 0;
}

///////////////////// `Test` and `gen_test_reseed` implementation /////////////////////

const string& get_task_id() {
    static auto task_id = [](string path) {
        auto end = path.rfind("ingen.");
        oi_assert(end != string::npos);
        auto beg = path.rfind('/', end);
        if (beg == string::npos) {
            beg = 0;
        } else {
            ++beg;
        }
        return path.substr(beg, end - beg);
    }(__FILE__);
    return task_id;
}

template<class Func, class... Args>
void gen_test(string test_name, uint_fast64_t seed, Func&& func, Args&&... args) {
    // Flush the buffers before reopening the next test.
    cout << flush;
    fflush(stdout);
    auto test_filename = get_task_id() + test_name + ".in";
    oi_assert(freopen(test_filename.c_str(), "w", stdout), "failed to save test ", test_filename);
    std::cerr << "Generating " << test_filename << "...\n";
    rng = oi::Random{seed};
    func(std::forward<decltype(args)>(args)...);
    // Flush the buffers before giving up control to the caller.
    cout << flush;
    fflush(stdout);
}

template<class Func, class... Args>
void gen_test_reseed(string test_name, Func&& func, Args&&... args) {
    // The new seed is created from the test name.
    uint_fast64_t seed = static_cast<uint_fast64_t>(hash<string_view>{}(test_name));
    gen_test(test_name, seed, func, args...);
}

Test::operator string() {
    string res = "";
    for (;;) {
        res += static_cast<char>('a' + id % ('z' - 'a' + 1));
        if (id <= 'z' - 'a') {
            break;
        }
        id = id / ('z' - 'a' + 1) - 1;
    }
    std::reverse(res.begin(), res.end());
    return to_string(group) + res;
}

Test Test::operator++(int) noexcept {
    Test res = *this;
    ++id;
    return res;
}

void Test::advance_group() noexcept {
    ++group;
    id = 0;
}
