// Kuba Ornatek
// Złożoność czasowa O(m + n * log(n)), Złożoność pamięciowa O(n)
// Rozwiązanie wzrocowe - drzewo przedziałowe przedział-przedział

#include<iostream>
#include<vector>
#include<algorithm>
#include<climits>
using namespace std;


class SegmentTree {
private:
    int n;
    vector<long long> tree, lazy;

    void propagate(int node, int start, int end) {
        if (lazy[node] != 0) {
            tree[node] += lazy[node];

            if (start != end) {
                lazy[node * 2] += lazy[node];
                lazy[node * 2 + 1] += lazy[node];
            }

            lazy[node] = 0;
        }
    }

    void rangeAdd(int node, int start, int end, int l, int r, long long val) {
        propagate(node, start, end);

        if (start > r || end < l) {
            return;
        }

        if (start >= l && end <= r) {
            lazy[node] += val;
            propagate(node, start, end);
            return;
        }

        int mid = (start + end) / 2;
        rangeAdd(node * 2, start, mid, l, r, val);
        rangeAdd(node * 2 + 1, mid + 1, end, l, r, val);

        tree[node] = max(tree[node * 2], tree[node * 2 + 1]);
    }

    long long rangeMax(int node, int start, int end, int l, int r) {
        propagate(node, start, end);

        if (start > r || end < l) {
            return LLONG_MIN;
        }

        if (start >= l && end <= r) {
            return tree[node];
        }

        int mid = (start + end) / 2;
        long long leftMax = rangeMax(node * 2, start, mid, l, r);
        long long rightMax = rangeMax(node * 2 + 1, mid + 1, end, l, r);

        return max(leftMax, rightMax);
    }

    int getN(int _n) {
        int i = 0;
        while ((1 << i) < _n) {
            i++;
        }
        return 1 << i;
    }

public:
    SegmentTree(int _n) {
        n = getN(_n);
        tree.resize(2 * n, 0); 
        lazy.resize(2 * n, 0); 
    }

    void rangeAdd(int l, int r, long long val) {
        if (val == 0) {
            return;
        }
        rangeAdd(1, 0, n - 1, l, r, val); 
    }

    long long rangeMax(int l, int r) {
        return rangeMax(1, 0, n - 1, l, r); 
    }

    void printTree() {
        for (int i = 1; i < n; i++) {
            rangeAdd(1, 0, n - 1, i, i, 0);
        }

        cerr << "Segment Tree (tree array):" << endl;

        int pow = 2;
        for (int i = 1; i < n; ++i) {
            cerr << tree[i] << " ";
            if (pow - 1 == i) {
                pow *= 2;
                cerr << endl;
            }
        }
        cerr << "\n";
    }
};


int main() {
    //cin.tie(0);
    //ios_base::sync_with_stdio(0);
    
    int n, m;
    cin >> n >> m;

    vector<long long> efficiency(n);
    vector<vector<pair<int, int>>> piw(n, vector<pair<int, int>>(2, {0, n - 1}));
    // piw[k][0] - przedział początku przedziału
    // piw[k][1] - przedział końca przedziału
    int a, b, t;

    for (int i = 0; i < n; i++) {
        cin >> efficiency[i];
        piw[i][0].second = i;
        piw[i][1].first = i;
    }

    for (int i = 0; i < m; i++) {
        cin >> t >> a >> b;
        t--; a--; b--;	// a chce? z b
        if (t == 0) {	// muszą być
            if (b < a) {
                piw[a][0].second = min(piw[a][0].second, b);
            } else {
                piw[a][1].first = max(piw[a][1].first, b);
            }
        } else {		// nie mogą być
            if (b < a) {
                piw[a][0].first = max(piw[a][0].first, b + 1);
            } else {
                piw[a][1].second = min(piw[a][1].second, b - 1);
            }
        }
    }

    SegmentTree st(n + 1);

    vector<pair<int, int>> add, substr;

    for (int i = 0; i < n; i++) {
        if (piw[i][0].first <= piw[i][0].second && piw[i][1].first <= piw[i][1].second) {
            add.push_back({piw[i][1].first, i});
            substr.push_back({piw[i][1].second, i});
        }
    }

    sort(add.begin(), add.end());
    sort(substr.begin(), substr.end());

    int _add = 0, _substr = 0;

    for (int i = 0; i < n; i++) {
        while (_add < (int) add.size() && add[_add].first <= i) {
            int idx = add[_add].second;
            st.rangeAdd(piw[idx][0].first, piw[idx][0].second, efficiency[idx]);
            _add++;
        }

        long long tmp = st.rangeMax(0, i + 1);
        st.rangeAdd(i + 1, i + 1, tmp);

        while (_substr < (int) substr.size() && substr[_substr].first <= i) {
            int idx = substr[_substr].second;
            st.rangeAdd(piw[idx][0].first, piw[idx][0].second, -efficiency[idx]);
            _substr++;
        }
    }

    // st.printTree();

    cout << st.rangeMax(0, n + 1) << "\n";
}