class SegmentTree:
    def __init__(self, n):
        self.n = self._get_n(n)
        self.tree = [0] * (2 * self.n)
        self.lazy = [0] * (2 * self.n)

    def _get_n(self, n):
        i = 0
        while (1 << i) < n:
            i += 1
        return 1 << i

    def _propagate(self, node, start, end):
        if self.lazy[node] != 0:
            self.tree[node] += self.lazy[node]

            if start != end:
                self.lazy[node * 2] += self.lazy[node]
                self.lazy[node * 2 + 1] += self.lazy[node]

            self.lazy[node] = 0

    def _range_add(self, node, start, end, l, r, val):
        self._propagate(node, start, end)

        if start > r or end < l:
            return

        if start >= l and end <= r:
            self.lazy[node] += val
            self._propagate(node, start, end)
            return

        mid = (start + end) // 2
        self._range_add(node * 2, start, mid, l, r, val)
        self._range_add(node * 2 + 1, mid + 1, end, l, r, val)

        self.tree[node] = max(self.tree[node * 2], self.tree[node * 2 + 1])

    def _range_max(self, node, start, end, l, r):
        self._propagate(node, start, end)

        if start > r or end < l:
            return float('-inf')

        if start >= l and end <= r:
            return self.tree[node]

        mid = (start + end) // 2
        left_max = self._range_max(node * 2, start, mid, l, r)
        right_max = self._range_max(node * 2 + 1, mid + 1, end, l, r)

        return max(left_max, right_max)

    def range_add(self, l, r, val):
        if val == 0:
            return
        self._range_add(1, 0, self.n - 1, l, r, val)

    def range_max(self, l, r):
        return self._range_max(1, 0, self.n - 1, l, r)

    def print_tree(self):
        for i in range(1, self.n):
            self._range_add(1, 0, self.n - 1, i, i, 0)

        print("Segment Tree (tree array):")

        pow_2 = 2
        for i in range(1, self.n):
            print(self.tree[i], end=" ")
            if pow_2 - 1 == i:
                pow_2 *= 2
                print()
        print()


n, m = map(int, input().split())

efficiency = list(map(int, input().split()))
piw = [[[0, n - 1], [0, n - 1]] for _ in range(n)]

for i in range(n):
	piw[i][0][1] = i;
	piw[i][1][0] = i;

for _ in range(m):
	t, a, b = map(int, input().split())
	t -= 1; a -= 1; b -= 1
	if (t == 0):
		if (b < a):
			piw[a][0][1] = min(piw[a][0][1], b)
		else:
			piw[a][1][0] = max(piw[a][1][0], b)
	else:
		if (b < a):
			piw[a][0][0] = max(piw[a][0][0], b + 1)
		else:
			piw[a][1][1] = min(piw[a][1][1], b - 1)


st = SegmentTree(n + 1)

add, substr = [], []

for i in range(n):
	if (piw[i][0][0] <= piw[i][0][1] and piw[i][1][0] <= piw[i][1][1]):
		add.append([piw[i][1][0], i]);
		substr.append([piw[i][1][1], i]);

add.sort()
substr.sort()

_add = 0
_substr = 0

for i in range(n):
	while (_add < len(add) and add[_add][0] <= i):
		idx = add[_add][1]
		st.range_add(piw[idx][0][0], piw[idx][0][1], efficiency[idx])
		_add += 1

	tmp = st.range_max(0, i + 1)
	st.range_add(i + 1, i + 1, tmp)

	while (_substr < len(substr) and substr[_substr][0] <= i):
		idx = substr[_substr][1]
		st.range_add(piw[idx][0][0], piw[idx][0][1], -efficiency[idx]);
		_substr += 1


print(st.range_max(0, n + 1))
